// Version/Precision tags are added programmatically on shader load

uniform vec3  uLightDif;
uniform mat4  mReflections;
uniform vec3  uEyePosition;
uniform float uMinOpacity;
uniform float uMinReflectivity;
uniform vec3  uOpaqueColor;
uniform float uOpaqueDepth;
uniform vec3  uFogColor;
uniform float uTime;
uniform float uWaterLevel;
uniform vec3 uFowColor;
uniform sampler2D reflection_sampler;
uniform sampler2D uFowTexture;
uniform sampler2D uSampleWaves;

varying float fogValue;
varying vec3  P;
varying vec3  L;

void main()
{
  /* Vertex on water surface */
  vec3 surfaceVertex = vec3(P.xy, uWaterLevel);

  vec3 surfaceNormal = texture2D(uSampleWaves, P.xy / 4.0 + vec2(0.008, 0.006) * uTime).rgb;
  surfaceNormal = normalize(surfaceNormal);
  vec3 V = normalize(uEyePosition - surfaceVertex);
  vec3 RL = -reflect(L, surfaceNormal);
  vec3 specular = pow(max(dot(V, RL), 0.0) + 0.002, 512.0) * uLightDif;

  /* Reflection angle */
  float cosT1 = V.z;
  /* Reflectance */
  float c = 1.0 - cosT1;
  float R = uMinReflectivity + (1.0 - uMinReflectivity) * c * c * c * c * c;

  /* Water density */
  float waterDepth = uWaterLevel - P.z;
  float waterThickness = waterDepth / max(cosT1, 0.01);
  float dWater = uMinOpacity + (1.0 - uMinOpacity) * sqrt(min(waterThickness / uOpaqueDepth, 1.0));
  /* Premultiply */
  vec3 waterColor = uOpaqueColor * dWater;

  vec4 vClipReflection = mReflections * vec4(P.xy, uWaterLevel, 1.0);
  vec2 vDeviceReflection = vClipReflection.st / vClipReflection.q;
  vec2 vTextureReflection = vec2(0.5, 0.5) + 0.5 * vDeviceReflection;

  vec4 reflectionTextureColor = texture2D(reflection_sampler, vTextureReflection);

  /* Framebuffer reflection can have alpha > 1 */
  reflectionTextureColor.a = 1.0;

  /* Combine colors */
  vec3 color = ((1.0 - R) * waterColor + R * reflectionTextureColor.rgb) + specular;
  float alpha = R + (1.0 - R) * dWater;

  /* Calculate FOW */
  #define FOW_TEXTURE_SCALE %
  float fow = texture2D(uFowTexture, P.xy * vec2(FOW_TEXTURE_SCALE, FOW_TEXTURE_SCALE)).r;
	
  /* Mix in fog */
  color = mix(color, uFogColor, fogValue);
  color = mix(uFowColor, color, fow);

  gl_FragColor = vec4(color, alpha);
 }